/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mss;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxGraphic {
    private GenModel mssModel;
    private GenModel base8210ResetModel;
    private GenModel pci8210Model;
    private GenModel pcmcia8210Model;
    private GenModel systemModel;
    private JdmBrowser mssJdmBrowser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private boolean v2MSS = false;
    private static final String PropertiesFile = "properties/Mss.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    private static final String bundleName = "ibm.nways.mss.Resources";
    private static final String cookiePath = "ibm.nways.mss.WCDefault";
    private static final int RASID = 19;
    private static final int RASSUB = 26;
    static final int startingX = 20;

    protected BoxGraphic(JdmBrowser jdmBrowser) {
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.mssJdmBrowser = jdmBrowser;
    }

    protected GraphicPanel getGraphicPanel() {
        WidgetCookie widgetCookie;
        String string;
        ModelInfo modelInfo;
        CookieTray cookieTray;
        GraphicContainer graphicContainer;
        block32: {
            Object object;
            Vector vector;
            block31: {
                Properties properties;
                Serializable serializable;
                graphicContainer = new GraphicContainer();
                vector = new Vector();
                try {
                    serializable = new URL(this.mssJdmBrowser.getDocumentBase(), PropertiesFile);
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "DocumentBase = " + this.mssJdmBrowser.getDocumentBase());
                    }
                    properties = new Properties();
                    properties.load(((URL)serializable).openStream());
                }
                catch (Exception exception) {
                    properties = null;
                    RAS.logError(19, 26, this, "getGraphicPanel()", "EXCEPTION_GETTING_PROPERTIES", (Object)(String.valueOf(this.mssJdmBrowser.getDocumentBase()) + PropertiesFile));
                }
                JdmLayout jdmLayout = (JdmLayout)this.mssJdmBrowser.getLayout();
                if (properties != null) {
                    serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "Layout = " + serializable);
                    }
                    int n = (Integer)serializable;
                    jdmLayout.setScheme(n);
                    String string2 = (String)((Hashtable)properties).get(fractKey);
                    object = new StringTokenizer(string2);
                    float[] fArray = new float[((StringTokenizer)object).countTokens()];
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object).nextToken();
                        try {
                            fArray[n2] = Float.valueOf(string3).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            RAS.logError(19, 26, this, "getGraphicPanel()", "EXCEPTION_CALCULATING_FRACTIONS", (Object)numberFormatException);
                            bl = false;
                        }
                        ++n2;
                    }
                    if (bl) {
                        jdmLayout.setFracts(fArray);
                    }
                }
                this.getBoxInfo();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName);
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getGraphicPanel()", "V2 MSS = " + this.v2MSS);
                }
                cookieTray = this.v2MSS ? new CookieTray(bundleName, new Point(20, 0), "mssv2.gif", "", this.mssJdmBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel") : new CookieTray(bundleName, new Point(20, 0), "Mss8210.gif", "", this.mssJdmBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
                graphicContainer.add((GraphicContainer)cookieTray);
                serializable = new GraphicHelp((BrowserApplet)this.mssJdmBrowser, new Point(0, 0), new HelpRef((Object)this));
                graphicContainer.add((GraphicComponent)serializable);
                WidgetCookie widgetCookie2 = new WidgetCookie("Rs232", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
                if (this.v2MSS) {
                    widgetCookie2.setLocation(new Point(154, 46));
                } else {
                    widgetCookie2.setLocation(new Point(62, 95));
                }
                cookieTray.AddWidget(widgetCookie2);
                WidgetCookie widgetCookie3 = new WidgetCookie("single1", bundleName, null, cookiePath, this.base8210ResetModel, this.mssJdmBrowser, 20, "ibm.nways.mss.Reset8210Panel");
                if (this.v2MSS) {
                    widgetCookie3.setLocation(new Point(241, 50));
                } else {
                    widgetCookie3.setLocation(new Point(208, 104));
                }
                cookieTray.AddWidget(widgetCookie3);
                try {
                    vector = this.pci8210Model.getRestOfInfo("Config", "default", null, null);
                }
                catch (Exception exception) {
                    RAS.logException(19, 26, this, "getGraphicPanel()", exception);
                }
                try {
                    modelInfo = (ModelInfo)vector.elementAt(1);
                    string = modelInfo.get("Config.Mss8210PCIAdapType").toString();
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "PCI slot #2 = " + string);
                    }
                    this.setPciImage(string, 2, cookieTray, modelInfo);
                }
                catch (Exception exception) {
                    RAS.logException(19, 26, this, "getGraphicPanel()", exception);
                    if (this.v2MSS) break block31;
                    object = new Integer(4);
                    this.setPciImage(((Integer)object).toString(), 2, cookieTray, null);
                }
            }
            try {
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getGraphicPanel()", "Slot 1");
                }
                modelInfo = (ModelInfo)vector.elementAt(0);
                string = modelInfo.get("Config.Mss8210PCIAdapType").toString();
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getGraphicPanel()", "PCI slot #1 type = " + string);
                }
                this.setPciImage(string, 1, cookieTray, modelInfo);
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "getGraphicPanel()", exception);
                if (this.v2MSS) break block32;
                object = new Integer(4);
                this.setPciImage(((Integer)object).toString(), 1, cookieTray, null);
            }
        }
        try {
            this.pcmcia_Info = this.pcmcia8210Model.getRestOfInfo("Config", "default", null, null);
        }
        catch (Exception exception) {
            RAS.logException(19, 26, this, "getGraphicPanel()", exception);
        }
        try {
            modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(0);
            string = modelInfo.get("Config.Mss8210PCAdapType").toString();
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, this, "getGraphicPanel()", "PCMCIA slot #1 = " + string);
            }
            widgetCookie = this.getPcmciaImage(string, 1, modelInfo);
            cookieTray.AddWidget(widgetCookie);
        }
        catch (Exception exception) {
            RAS.logException(19, 26, this, "getGraphicPanel()", exception);
        }
        try {
            modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(1);
            string = modelInfo.get("Config.Mss8210PCAdapType").toString();
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, this, "getGraphicPanel()", "PCMCIA slot #2 type = " + string);
            }
            widgetCookie = this.getPcmciaImage(string, 2, modelInfo);
            cookieTray.AddWidget(widgetCookie);
        }
        catch (Exception exception) {
            RAS.logException(19, 26, this, "getGraphicPanel()", exception);
        }
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.mssJdmBrowser, (Component)graphicContainer);
        return graphicPanel;
    }

    private void getBoxInfo() {
        if (this.pci8210Model == null) {
            try {
                this.pci8210Model = (GenModel)this.mssModel.getComponent("Pci8210");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getBoxInfo()", "Got PCI8210");
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "getGraphicPanel()", exception);
            }
        }
        if (this.pcmcia8210Model == null) {
            try {
                this.pcmcia8210Model = (GenModel)this.mssModel.getComponent("Pcmcia8210");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getBoxInfo()", "Got PCMICA 8210");
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "getGraphicPanel()", exception);
            }
        }
        if (this.base8210ResetModel == null) {
            try {
                this.base8210ResetModel = (GenModel)this.mssModel.getComponent("Base8210Reset");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getBoxInfo()", "Got base8210 Reset");
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "EXCEPTION_GETTING_MODELINFO", exception);
            }
        }
        if (this.systemModel == null) {
            try {
                this.systemModel = (GenModel)this.mssModel.getComponent("System");
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getBoxInfo()", "Got System Model");
                    return;
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "EXCEPTION_GETTING_MODELINFO", exception);
                return;
            }
        }
    }

    protected void setMssModel(GenModel genModel) {
        this.mssModel = genModel;
    }

    protected void setMSSV2(boolean bl) {
        this.v2MSS = bl;
    }

    private void setPciImage(String string, int n, CookieTray cookieTray, ModelInfo modelInfo) {
        Integer n2 = new Integer(string);
        int n3 = n2;
        switch (n3) {
            case 1: {
                WidgetCookie widgetCookie = this.AtmPCI(modelInfo, n, this.v2MSS, null);
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "setPciImage()", "SetFlyOver UNKNOWN");
                }
                widgetCookie.SetFlyover("UNKNOWN");
                cookieTray.AddWidget(widgetCookie);
                return;
            }
            case 2: {
                WidgetCookie widgetCookie;
                if (this.v2MSS) {
                    widgetCookie = this.atmCoverPlate(n);
                    cookieTray.AddWidget(widgetCookie);
                }
                widgetCookie = this.AtmPCI(modelInfo, n, this.v2MSS, null);
                widgetCookie.SetFlyover("ATM PCI Adapter");
                cookieTray.AddWidget(widgetCookie);
                return;
            }
            case 3: {
                WidgetCookie widgetCookie = this.FddiEmptyUFC(n, this.v2MSS);
                cookieTray.AddWidget(widgetCookie);
                widgetCookie = this.AtmPCI(modelInfo, n, this.v2MSS, "A");
                widgetCookie.SetFlyover("fddiaport");
                cookieTray.AddWidget(widgetCookie);
                widgetCookie = this.FddiBypass(modelInfo, n, this.v2MSS);
                widgetCookie.SetFlyover("bypass");
                cookieTray.AddWidget(widgetCookie);
                widgetCookie = this.AtmPCI(modelInfo, n, this.v2MSS, "B");
                widgetCookie.SetFlyover("fddibport");
                cookieTray.AddWidget(widgetCookie);
                return;
            }
            case 4: {
                if (this.v2MSS) break;
                WidgetCookie widgetCookie = this.NotPresentPCI(n, this.v2MSS);
                cookieTray.AddWidget(widgetCookie);
                return;
            }
            default: {
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "setPciImage()", "Unexpected PCI type = " + string);
                }
                if (this.v2MSS) break;
                WidgetCookie widgetCookie = this.NotPresentPCI(n, this.v2MSS);
                cookieTray.AddWidget(widgetCookie);
            }
        }
    }

    private WidgetCookie getPcmciaImage(String string, int n, ModelInfo modelInfo) {
        WidgetCookie widgetCookie;
        Integer n2 = new Integer(string);
        int n3 = n2;
        switch (n3) {
            case 2: {
                widgetCookie = this.Harddrive8210PCA(modelInfo, n, this.v2MSS);
                break;
            }
            case 3: {
                widgetCookie = this.Modem8210PCA(modelInfo, n, this.v2MSS);
                break;
            }
            case 5: {
                widgetCookie = this.Flash8210PCA(modelInfo, n, this.v2MSS);
                break;
            }
            case 1: {
                widgetCookie = this.Unknown8210PCA(modelInfo, n, this.v2MSS);
                break;
            }
            case 4: {
                if (!this.v2MSS) {
                    widgetCookie = this.NotPresent8210PCA(modelInfo, n, this.v2MSS);
                    break;
                }
                widgetCookie = null;
                break;
            }
            default: {
                widgetCookie = null;
                if (!RAS.isEnabled(19, 26)) break;
                RAS.trace(19, 26, this, "getPcmciaImage()", "Unexpected pcmcia type = " + string);
            }
        }
        return widgetCookie;
    }

    private WidgetCookie AtmPCI(ModelInfo modelInfo, int n, boolean bl, String string) {
        WidgetCookie widgetCookie;
        try {
            widgetCookie = new WidgetCookie("sc", bundleName, modelInfo, cookiePath, this.pci8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PciAdapterPanel");
        }
        catch (Exception exception) {
            RAS.logException(19, 26, this, "AtmPCI()", exception);
            widgetCookie = null;
        }
        if (widgetCookie != null) {
            if (string == null) {
                if (!bl) {
                    if (n == 1) {
                        widgetCookie.setLocation(new Point(315, 51));
                    } else {
                        widgetCookie.setLocation(new Point(315, 16));
                    }
                } else if (n == 1) {
                    widgetCookie.setLocation(new Point(44, 9));
                } else {
                    widgetCookie.setLocation(new Point(509, 9));
                }
            } else if (!bl) {
                if (n == 1) {
                    if (string.equals("A")) {
                        widgetCookie.setLocation(new Point(341, 53));
                    } else {
                        widgetCookie.setLocation(new Point(289, 53));
                    }
                } else if (string.equals("A")) {
                    widgetCookie.setLocation(new Point(341, 18));
                } else {
                    widgetCookie.setLocation(new Point(289, 18));
                }
            } else if (n == 1) {
                if (string.equals("A")) {
                    widgetCookie.setLocation(new Point(93, 9));
                } else {
                    widgetCookie.setLocation(new Point(38, 9));
                }
            } else if (string.equals("A")) {
                widgetCookie.setLocation(new Point(559, 9));
            } else {
                widgetCookie.setLocation(new Point(505, 9));
            }
        }
        return widgetCookie;
    }

    private WidgetCookie atmCoverPlate(int n) {
        WidgetCookie widgetCookie = new WidgetCookie("atmUFC", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
        if (n == 1) {
            widgetCookie.setLocation(new Point(29, 8));
        } else {
            widgetCookie.setLocation(new Point(495, 16));
        }
        return widgetCookie;
    }

    private WidgetCookie NotPresentPCI(int n, boolean bl) {
        WidgetCookie widgetCookie = new WidgetCookie("emptyUFC", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
        if (n == 1) {
            widgetCookie.setLocation(new Point(256, 46));
        } else {
            widgetCookie.setLocation(new Point(256, 12));
        }
        return widgetCookie;
    }

    private WidgetCookie Harddrive8210PCA(ModelInfo modelInfo, int n, boolean bl) {
        String string = !bl ? "hdrive" : "singlehdrive";
        WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, cookiePath, this.pcmcia8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapter8210Panel");
        if (!bl) {
            if (n == 1) {
                widgetCookie.setLocation(new Point(390, 97));
            } else {
                widgetCookie.setLocation(new Point(502, 97));
            }
        } else if (n == 1) {
            widgetCookie.setLocation(new Point(518, 39));
        } else {
            widgetCookie.setLocation(new Point(518, 39));
        }
        return widgetCookie;
    }

    private WidgetCookie Modem8210PCA(ModelInfo modelInfo, int n, boolean bl) {
        String string = !bl ? "modem" : "singlemodem";
        WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, cookiePath, this.pcmcia8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapter8210Panel");
        if (!bl) {
            if (n == 1) {
                widgetCookie.setLocation(new Point(390, 97));
            } else {
                widgetCookie.setLocation(new Point(502, 97));
            }
        } else if (n == 1) {
            widgetCookie.setLocation(new Point(518, 42));
        } else {
            widgetCookie.setLocation(new Point(518, 50));
        }
        return widgetCookie;
    }

    private WidgetCookie Flash8210PCA(ModelInfo modelInfo, int n, boolean bl) {
        String string = !bl ? "flash" : "singleflash";
        WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, cookiePath, this.pcmcia8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapter8210Panel");
        if (!bl) {
            if (n == 1) {
                widgetCookie.setLocation(new Point(390, 97));
            } else {
                widgetCookie.setLocation(new Point(502, 97));
            }
        } else if (n == 1) {
            widgetCookie.setLocation(new Point(517, 42));
        } else {
            widgetCookie.setLocation(new Point(517, 50));
        }
        return widgetCookie;
    }

    private WidgetCookie Unknown8210PCA(ModelInfo modelInfo, int n, boolean bl) {
        String string = !bl ? "Pcmcia8210" : "singlePcmcia";
        WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, cookiePath, this.pcmcia8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapter8210Panel");
        if (!bl) {
            if (n == 1) {
                widgetCookie.setLocation(new Point(390, 97));
            } else {
                widgetCookie.setLocation(new Point(502, 97));
            }
        } else if (n == 1) {
            widgetCookie.setLocation(new Point(518, 42));
        } else {
            widgetCookie.setLocation(new Point(518, 50));
        }
        return widgetCookie;
    }

    private WidgetCookie NotPresent8210PCA(ModelInfo modelInfo, int n, boolean bl) {
        String string = "epcmcia";
        WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, cookiePath, this.pcmcia8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapter8210Panel");
        if (!bl) {
            if (n == 1) {
                widgetCookie.setLocation(new Point(391, 97));
            } else {
                widgetCookie.setLocation(new Point(505, 97));
            }
        } else if (n == 1) {
            widgetCookie.setLocation(new Point(391, 97));
        } else {
            widgetCookie.setLocation(new Point(505, 97));
        }
        return widgetCookie;
    }

    private WidgetCookie FddiBypass(ModelInfo modelInfo, int n, boolean bl) {
        WidgetCookie widgetCookie;
        try {
            widgetCookie = new WidgetCookie("fddi", bundleName, modelInfo, cookiePath, this.pci8210Model, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PciAdapterPanel");
        }
        catch (Exception exception) {
            RAS.logException(19, 26, this, "FddiBypass()", exception);
            widgetCookie = null;
        }
        if (widgetCookie != null) {
            if (!bl) {
                if (n == 1) {
                    widgetCookie.setLocation(new Point(386, 53));
                } else {
                    widgetCookie.setLocation(new Point(386, 18));
                }
            } else if (n == 1) {
                widgetCookie.setLocation(new Point(137, 9));
            } else {
                widgetCookie.setLocation(new Point(602, 9));
            }
        }
        return widgetCookie;
    }

    private WidgetCookie FddiEmptyUFC(int n, boolean bl) {
        WidgetCookie widgetCookie;
        if (!this.v2MSS) {
            try {
                widgetCookie = new WidgetCookie("fddi10sm", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "FddiEmptyUFC()", exception);
                widgetCookie = null;
            }
            if (widgetCookie != null) {
                if (n == 1) {
                    widgetCookie.setLocation(new Point(256, 46));
                } else {
                    widgetCookie.setLocation(new Point(256, 12));
                }
            }
        } else {
            try {
                widgetCookie = new WidgetCookie("fddi2portUFC", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
            }
            catch (Exception exception) {
                RAS.logException(19, 26, this, "FddiEmptyUFC()", exception);
                widgetCookie = null;
            }
            if (widgetCookie != null) {
                if (n == 1) {
                    widgetCookie.setLocation(new Point(29, 8));
                } else {
                    widgetCookie.setLocation(new Point(495, 16));
                }
            }
        }
        return widgetCookie;
    }
}

